//
//  ConflictViewController.m
//  Handling Conflicts in iCloud Documents
//
//  Created by Vandad NP on 16/10/2011.
//  Copyright (c) 2011 __MyCompanyName__. All rights reserved.
//

#import "ConflictViewController.h"

@implementation ConflictViewController

@synthesize tableViewVersions;

- (id) initWithNibName:(NSString *)nibNameOrNil 
                bundle:(NSBundle *)nibBundleOrNil
     tableViewDelegate:(id<UITableViewDelegate>)paramTableViewDelegate
   tableViewDataSource:(id<UITableViewDataSource>)paramTableViewDataSource{
  
  self = [super initWithNibName:nibNameOrNil
                         bundle:nibBundleOrNil];
  
  if (self != nil){
    /* Na tym etapie widok jeszcze nie istnieje, więc widok tabeli ma wielkość
      zerową, która zostanie zmieniona po wczytaniu widoku. */
    tableViewVersions = [[UITableView alloc] 
                         initWithFrame:CGRectZero
                         style:UITableViewStylePlain];
    tableViewVersions.delegate = paramTableViewDelegate;
    tableViewVersions.dataSource = paramTableViewDataSource;
  }
  
  return self;
  
}

- (id) initWithNibName:(NSString *)nibNameOrNil 
                bundle:(NSBundle *)nibBundleOrNil{
  
  return [self initWithNibName:nibNameOrNil
                        bundle:nibBundleOrNil
             tableViewDelegate:nil
           tableViewDataSource:nil];
  
}

- (void)viewDidLoad{
  [super viewDidLoad];
  
  self.view.autoresizingMask = UIViewAutoresizingFlexibleWidth | 
                               UIViewAutoresizingFlexibleHeight;
  self.tableViewVersions.autoresizingMask = self.view.autoresizingMask;
  self.tableViewVersions.frame = self.view.bounds;
  [self.view addSubview:self.tableViewVersions];
  
}

- (void)viewDidUnload{
  [self setTableViewVersions:nil];
  [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

@end
